#ifndef DSP32CORE_H
#define DSP32CORE_H
class Dsp32Core : virtual public Core {
	friend Dsp32Context;
protected:
	int	dsp32c;
	int	floatcall;

	int	REG_FP();
	int	REG_AP();
	int	REG_SP();
	int	REG_PC();
	int	nregs();
	int	cntxtbytes();
	int	argdir();
	int	argstart();
virtual	char	*dumppipeline();
	long	callingpc(long);
	long	callingfp(long);
	long	instrafterjsr();
	Asm	*newAsm();
	void	newSymTab(long);
	char	*pokedbl(long,double,int);
	char	*poke(long,long,int);
	long	saved(Frame*,int,int);
	char	*regname(int);
	Cslfd	*peek(long,Cslfd* =PEEKFAIL);
	Frame	frameabove(long);
	int	atjsr(long);
	int	atreturn(long);
	char	*stepprolog();
	char	*docall(long,int);
	long	apforcall(int);
	long	returnregloc();
	double	dsptod(long);
	long	dtodsp(double);
	Context	*newContext();
public:
		Dsp32Core();
};

class Dsp32Context : public Context {
	Dsp32Core *dspcore;
public:
		Dsp32Context(Dsp32Core*c);
	void	save();
};
#endif /* DSP32CORE_H */
